#!/bin/bash

RANGE=(1 2 3 4 8 10 12 16 24 32 40 56 64)
EXECUTABLE=/u/training/aweeden/fire/mpi/fire-mpi
PROBLEM_SIZE=1300
ARGS="-t ${PROBLEM_SIZE} -r ${PROBLEM_SIZE} -c ${PROBLEM_SIZE}"
NUM_TRIALS=5
OUTPUT_FILE=scale-mpi.out
export OMP_NUM_THREADS=1

if [ -f ${OUTPUT_FILE} ]; then
  echo -n "Warning: file '${OUTPUT_FILE}' exists and will be deleted. Continue? [y/N] "
  read option;
  if [ "${option}" != "y" ]; then
    echo "Aborting";
    exit;
  fi;
fi

rm -f ${OUTPUT_FILE}

for i in ${RANGE[*]}; do
  np=${i};
  t=0;
  j=0;
  while [ "${j}" -lt "${NUM_TRIALS}" ]; do
    echo "${i} processes, trial $((${j} + 1)) of ${NUM_TRIALS}..."
    realTime=$((time aprun -n ${np} -d ${OMP_NUM_THREADS} ${EXECUTABLE} ${ARGS}) 2>&1 | grep real | awk '{print $2}' | sed 's/s//');
    min=${realTime%%m*};
    sec=${realTime##*m};
    sec=$(echo "scale=3; ${min} * 60 + ${sec}" | bc -l);
    echo "Real time = ${sec}";
    t=$(echo "scale=3; ${t} + ${sec}" | bc -l);
    j=$((${j} + 1));
  done;
  t=$(echo "scale=3; ${t} / ${NUM_TRIALS}" | bc -l);
  echo "${np},${t}" >> ${OUTPUT_FILE};
done
echo "Run complete, output file is '${OUTPUT_FILE}'"

