#!/bin/bash

EXECUTABLE=./fire-cuda
RANGE=(1000000 2000000 4000000 8000000 16000000)
NUM_TRIALS=5
OUTPUT_FILE=scale-cuda.out

if [ -f ${OUTPUT_FILE} ]; then
  echo -n "Warning: file '${OUTPUT_FILE}' exists and will be deleted. Continue? [y/N] "
  read option;
  if [ "${option}" != "y" ]; then
    echo "Aborting";
    exit;
  fi;
fi

rm -f ${OUTPUT_FILE}

for i in ${RANGE[*]}; do
  problemSize=$(echo "sqrt(${i})" | bc);
  ARGS="-r ${problemSize} -c ${problemSize} -t ${problemSize}";
  t=0;
  j=0;
  while [ "${j}" -lt "${NUM_TRIALS}" ]; do
    echo "${i} threads, trial $((${j} + 1)) of ${NUM_TRIALS}..."
    realTime=$((time aprun -n 1 ${EXECUTABLE} ${ARGS}) 2>&1 | grep real | awk '{print $2}' | sed 's/s//');
    min=${realTime%%m*};
    sec=${realTime##*m};
    sec=$(echo "scale=3; ${min} * 60 + ${sec}" | bc -l);
    echo "Real time = ${sec}";
    t=$(echo "scale=3; ${t} + ${sec}" | bc -l);
    j=$((${j} + 1));
  done;
  t=$(echo "scale=3; ${t} / ${NUM_TRIALS}" | bc -l);
  echo "${i},${t}" >> ${OUTPUT_FILE};
done
echo "Run complete, output file is '${OUTPUT_FILE}'"

